<?php
// get_last_sales.php
date_default_timezone_set('America/Guatemala'); // Ajusta la zona horaria
include 'db_connection.php';
include 'sucursal_config.php';

// Obtener la fecha actual y la fecha de hace 2 días
$fecha_actual = date('Y-m-d');
$fecha_dos_dias = date('Y-m-d', strtotime('-1 day')); // Incluye hoy y ayer (2 días)

// Obtener las ventas normales de los últimos 2 días
$sqlNormal = "SELECT id, fecha_y_hora, total, 'Normal' AS tipo
              FROM ventas
              WHERE sucursal_id = ? AND DATE(fecha_y_hora) >= ?
              ORDER BY fecha_y_hora DESC";
$stmtN = $conn->prepare($sqlNormal);
$stmtN->bind_param("is", $sucursal_id, $fecha_dos_dias);
$stmtN->execute();
$resN = $stmtN->get_result();
$ventas = [];

while ($rowN = $resN->fetch_assoc()) {
    $ventas[] = $rowN;
}

// Obtener las ventas especiales de los últimos 2 días
$sqlEspecial = "SELECT id, fecha_y_hora, precio AS total, 'Especial' AS tipo
                FROM ventas_especiales
                WHERE sucursal_id = ? AND DATE(fecha_y_hora) >= ?
                ORDER BY fecha_y_hora DESC";
$stmtE = $conn->prepare($sqlEspecial);
$stmtE->bind_param("is", $sucursal_id, $fecha_dos_dias);
$stmtE->execute();
$resE = $stmtE->get_result();

while ($rowE = $resE->fetch_assoc()) {
    $ventas[] = $rowE;
}

// Ordenar todas las ventas por fecha y hora descendente
usort($ventas, function($a, $b) {
    return strtotime($b['fecha_y_hora']) - strtotime($a['fecha_y_hora']);
});

// Formatear las fechas antes de enviar
foreach ($ventas as &$venta) {
    $venta['fecha_y_hora'] = date('d/m/Y H:i', strtotime($venta['fecha_y_hora']));
}

usort($ventas, function($a, $b) {
    return strtotime($b['fecha_y_hora']) - strtotime($a['fecha_y_hora']);
});

// Preparar respuesta
echo json_encode([
    'success' => true,
    'ventas' => $ventas
]);
?>
