<?php
// get_sucursal_nombre.php
date_default_timezone_set('America/Guatemala'); // Ajusta la zona horaria según tu ubicación
include 'db_connection.php';
include 'sucursal_config.php';

$sql = "SELECT nombre FROM sucursales WHERE id = ? LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $sucursal_id);
$stmt->execute();
$res = $stmt->get_result();

if ($res && $row = $res->fetch_assoc()) {
    echo json_encode([
        'success' => true,
        'nombre_sucursal' => $row['nombre']
    ]);
} else {
    echo json_encode(['success' => false, 'nombre_sucursal' => '']);
}
?>
