<?php
include 'conexion.php';
include 'sucursal_config.php';

$query = "SELECT t.*, 
          s1.nombre as origen_nombre,
          s2.nombre as destino_nombre,
          t.fecha_traslado
          FROM traslados t
          JOIN sucursales s1 ON t.sucursal_origen = s1.id
          JOIN sucursales s2 ON t.sucursal_destino = s2.id
          WHERE (t.sucursal_origen = $sucursal_id OR t.sucursal_destino = $sucursal_id)
          AND t.estado = 'pendiente'
          ORDER BY t.fecha_traslado DESC";

$result = mysqli_query($conexion, $query);
?>

<table class="table table-striped">
    <thead>
        <tr>
            <th>Fecha</th>
            <th>Origen</th>
            <th>Destino</th>
            <th>Estado</th>
            <th>Acciones</th>
        </tr>
    </thead>
    <tbody>
        <?php while($row = mysqli_fetch_assoc($result)): ?>
        <tr>
            <td><?php echo date('d/m/Y H:i', strtotime($row['fecha_traslado'])); ?></td>
            <td><?php echo $row['origen_nombre']; ?></td>
            <td><?php echo $row['destino_nombre']; ?></td>
            <td><?php echo ucfirst($row['estado']); ?></td>
            <td>
                <button class="btn btn-sm btn-info ver-detalles" data-id="<?php echo $row['id']; ?>">
                    Ver Detalles
                </button>
                <?php if($row['sucursal_destino'] == $sucursal_id): ?>
                <button class="btn btn-sm btn-success aceptar-traslado" data-id="<?php echo $row['id']; ?>">
                    Aceptar
                </button>
                <?php endif; ?>
            </td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>