<?php
include 'db.php';

header("Content-Type: application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=ventas_facturadas.xls");

$sucursal = $_GET['sucursal'] ?? '';
$fecha_inicio = $_GET['fecha_inicio'] ?? '';
$fecha_fin = $_GET['fecha_fin'] ?? '';

$facturado = $_GET['facturado'] ?? '';
$estado_factura = $_GET['estado_factura'] ?? '';

$where = "WHERE 1=1";

if ($sucursal !== '') {
    $where .= " AND v.sucursal_id = '$sucursal'";
}

if ($fecha_inicio !== '' && $fecha_fin !== '') {
    $where .= " AND DATE(v.fecha_y_hora) BETWEEN '$fecha_inicio' AND '$fecha_fin'";
} elseif ($fecha_inicio !== '') {
    $where .= " AND DATE(v.fecha_y_hora) = '$fecha_inicio'";
}

if ($facturado !== '') {
    $facturado_valor = ($facturado === 'SI') ? '1' : '0';
    $where .= " AND dv.facturado = '$facturado_valor'";
}

if ($estado_factura !== '') {
    $where .= " AND dv.estado_factura = '$estado_factura'";
}

// --- MODIFICACIÓN AQUÍ ---
// Se agregó p.exento_iva a la consulta
$query = "SELECT v.id AS venta_id, v.fecha_y_hora, v.total, s.nombre AS sucursal, 
                 dv.producto_id, dv.cantidad, dv.precio, dv.subtotal, p.NombreComercial, p.exento_iva
          FROM ventas v
          JOIN detalle_ventas dv ON v.id = dv.venta_id
          JOIN productos p ON dv.producto_id = p.id
          JOIN sucursales s ON v.sucursal_id = s.id
          $where
          ORDER BY v.fecha_y_hora DESC";

$result = $conn->query($query);

echo "<table border='1'>
<tr>
    <th>Venta ID</th>
    <th>Fecha</th>
    <th>Sucursal</th>
    <th>Producto</th>
    <th>Cantidad</th>
    <th>Precio</th>
    <th>Subtotal</th>
    <th>Total Venta</th>
    <th>Exento IVA</th>
</tr>";

while ($row = $result->fetch_assoc()) {
    // --- MODIFICACIÓN AQUÍ ---
    // Se muestra "Sí" o "No" basado en el valor de exento_iva
    $exento_texto = ($row['exento_iva'] == 1) ? 'Sí' : 'No';
    echo "<tr>
        <td>{$row['venta_id']}</td>
        <td>{$row['fecha_y_hora']}</td>
        <td>{$row['sucursal']}</td>
        <td>{$row['NombreComercial']}</td>
        <td>{$row['cantidad']}</td>
        <td>{$row['precio']}</td>
        <td>{$row['subtotal']}</td>
        <td>{$row['total']}</td>
        <td>{$exento_texto}</td>
    </tr>";
}

echo "</table>";
?>