<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Filtro de Ventas Facturadas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-4">
    <h2 class="mb-4">Ventas Facturadas - Filtro por Fecha</h2>

    <div class="row g-3 mb-4">
        <div class="col-md-2">
            <label class="form-label">Sucursal</label>
            <select id="sucursal" class="form-select">
                <option value="">Todas</option>
                <?php
                $result = $conn->query("SELECT * FROM sucursales");
                while ($row = $result->fetch_assoc()) {
                    echo "<option value='{$row['id']}'>{$row['nombre']}</option>";
                }
                ?>
            </select>
        </div>
        <div class="col-md-2">
            <label class="form-label">Desde</label>
            <input type="date" id="fecha_inicio" class="form-control">
        </div>
        <div class="col-md-2">
            <label class="form-label">Hasta</label>
            <input type="date" id="fecha_fin" class="form-control">
        </div>
        <div class="col-md-3">
            <label class="form-label">Estado Facturacin</label>
            <select id="facturado" class="form-select">
                <option value="">Todos</option>
                <option value="SI">Facturado</option>
                <option value="NO">No Facturado</option>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label">Estado Factura</label>
            <select id="estado_factura" class="form-select">
                <option value="">Todos</option>
                <option value="PENDIENTE">Pendiente</option>
                <option value="FACTURADO">Facturado</option>
            </select>
        </div>
    </div>

    <button class="btn btn-primary mb-3" onclick="filtrar()">Buscar</button>
    <!-- Agrega este botn justo debajo del botn de Buscar -->
<button class="btn btn-success mb-3 ms-2" onclick="exportarExcel()">Exportar a Excel</button>

<script>
function exportarExcel() {
    const data = {
        sucursal: document.getElementById('sucursal').value,
        fecha_inicio: document.getElementById('fecha_inicio').value,
        fecha_fin: document.getElementById('fecha_fin').value,
        facturado: document.getElementById('facturado').value,
        estado_factura: document.getElementById('estado_factura').value
    };

    const params = new URLSearchParams(data).toString();
    const url = `export_excel.php?${params}`;
    window.open(url, "_blank");
}
</script>


    <div id="resultado"></div>
</div>

<script>
function filtrar() {
    const data = {
        sucursal: document.getElementById('sucursal').value,
        fecha_inicio: document.getElementById('fecha_inicio').value,
        fecha_fin: document.getElementById('fecha_fin').value,
        facturado: document.getElementById('facturado').value,
        estado_factura: document.getElementById('estado_factura').value
    };

    const xhr = new XMLHttpRequest();
    xhr.open("POST", "fetch_data.php", true);
    xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    xhr.onload = function () {
        document.getElementById("resultado").innerHTML = this.responseText;
    };

    const params = new URLSearchParams(data).toString();
    xhr.send(params);
}
</script>
</body>
</html>